
/**********************************************************************/
/*                   C D U T I L . H                                  */
/**------------------------------------------------------------------**/
/* Task           : Header file for CDUTIL.C                          */
/**------------------------------------------------------------------**/
/* Author          : Michael Tischer / Bruno Jennrich                 */
/* Developed on    : 04/08/94                                         */
/* Last update     : 04/18/94                                         */
/**------------------------------------------------------------------**/
/* COMPILER        : Borland C++ 3.1, Microsoft Visual C++  1.5       */
/**********************************************************************/
#ifndef __INC_CDUTIL_H
#define __INC_CDUTIL_H

#include "types.h"

/* The structure variables marked '=' in the documentation            */
/* must be initialized by the programmer. The                         */
/* other fields/elements are returned by the device driver.           */

/*- Addressing Modes --------------------------------------------------*/
#define HSG 0
#define REDBOOK 1

/*- MSCDEX - Function codes ( passed in AL ) -------------------------*/
#define MSCDEX_GET_NO_OF_DRIVE_LETTERS        0x00
#define MSCDEX_GET_DRIVE_DEVICE_LIST          0x01
  typedef struct tagDevElement
  { BYTE           bSubUnit;                     /* Number of SubUnit */
    LPDeviceHeader lpDeviceHeader;       /* Address of device headers */
  } DevElement;
  typedef DevElement _FP *LPDevElement;

#define MSCDEX_GET_COPYRIGHT_FILENAME         0x02
#define MSCDEX_GET_ABSTRACT_FILENAME          0x03
#define MSCDEX_GET_BIB_DOC_FILENAME           0x04
#define MSCDEX_READ_VTOC                      0x05
#define MSCDEX_DEBUG_ON                       0x06
#define MSCDEX_DEBUG_OFF                      0x07
#define MSCDEX_ABSOLUTE_DISK_READ             0x08
#define MSCDEX_ABSOLUTE_DISK_WRITE            0x09
#define MSCDEX_RESERVED                       0x0A

/*- MSCDEX - Functions V2.00 and above -------------------------------------*/
#define MSCDEX200_CD_ROM_DRIVE_CHECK          0x0B
#define MSCDEX200_GET_VERSION                 0x0C
#define MSCDEX200_GET_DRIVE_LETTERS           0x0D
#define MSCDEX200_GETSET_VD_PREFERENCE        0x0E
#define MSCDEX200_GET_DIRECTORY_ENTRY         0x0F
#define DIRECT_COPY 0
#define STRUCT_COPY 1

/*- MSCDEX - Functions V2.10 and above -------------------------------*/
#define MSCDEX210_SEND_DEVICE_REQUEST         0x10

/*- Number of Multiplex-Interrupt ------------------------------------*/
#define DOS_MULTIPLEX_INT                     0x2F

/*- ID code of MSCDEX interrupt calls --------------------------------*/
#define MSCDEX_MULTIPLEX_CODE  (0x1500)
#define MSCDEX_MUXCODE( code ) ( MSCDEX_MULTIPLEX_CODE | ( code ) )

/*- Prototypes -------------------------------------------------------*/
LONG Time2Frame( INT iMin, INT iSec, INT iFrame );
LONG Time2HSG( INT iMin, INT iSec, INT iFrame );
LONG Time2REDBOOK( INT iMin, INT iSec, INT iFrame );
VOID Frame2Time( LONG lFrame, LPINT lpiMin,
                              LPINT lpiSec,
                              LPINT lpiFrame );
VOID REDBOOK2Time( LONG lREDBOOK, LPINT lpiMin,
                                  LPINT lpiSec,
                                  LPINT lpiFrame );
VOID HSG2Time( LONG lHSG, LPINT lpiMin,
                          LPINT lpiSec,
                          LPINT lpiFrame );
LONG REDBOOK2HSG( LONG lREDBOOK );
LONG HSG2REDBOOK( LONG lHSG );
INT MSCDEX_GetNumberOfDriveLetters( LPINT lpiNumber,
                                    LPINT lpiStartLetter );
INT MSCDEX_Installed( VOID );
INT MSCDEX_GetCDRomDriveDeviceList( LPDevElement lpDevElement );
INT MSCDEX_GetCopyrightFilename( INT       iCD_Drive_Letter,
                                 LPCHAR    lpName );
INT MSCDEX_GetAbstractFilename( INT       iCD_Drive_Letter,
                                LPCHAR    lpName );
INT MSCDEX_GetBibDocFilename( INT       iCD_Drive_Letter,
                              LPCHAR    lpName );
INT MSCDEX_ReadVTOC( INT       iCD_Drive_Letter,
                     LPBYTE    lpSector,
                     INT       iNumSec );
INT MSCDEX_DebugOn( VOID );
INT MSCDEX_DebugOff( VOID );
INT MSCDEX_AbsoluteRead( INT       iCD_Drive_Letter,
                         LPBYTE    lpSector,
                         INT       iSecCnt,
                         LONG      lSecStart );
INT MSCDEX_AbsoluteWrite( INT       iCD_Drive_Letter,
                          LPBYTE    lpSector,
                          INT       iSecCnt,
                          LONG      lSecStart );
INT MSCDEX200_CDRomDriveCheck( INT iCD_Drive_Letter );
INT MSCDEX200_GetVersion( VOID );
INT MSCDEX200_GetCDRomDriveLetters( LPCHAR lpLetters );
INT MSCDEX200_GetVDPreference( INT   iCD_Drive_Letter,
                               LPINT lpiPreference );
INT MSCDEX200_SetVDPreference( INT iCD_Drive_Letter,
                               INT iPreference );
INT MSCDEX200_GetDirectoryEntry( INT       iCD_Drive_Letter,
                                 INT       iCopyFlag,
                                 LPCHAR    lpPathName,
                                 LPVOID    lpData,
                                 LPINT     lpiHSG );
INT MSCDEX_ReadWriteReq( INT       iCD_Drive_Letter,
                         INT       iCommand,
                         LPVOID    lpControlBlock,
                         INT       iControlBlockSize );
INT MSCDEX210_SendDeviceRequest( INT             iCD_Drive_Letter,
                                 LPRequestHeader lpReqHdr );
INT MSCDEX_SendDeviceRequest( INT             iCD_Drive_Letter,
                              LPRequestHeader lpReqHdr );

#endif  /*- #ifndef _INC_CDUTIL_H ------------------------------------*/
